// $Id: CSelectableMenuItem.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CSelectableMenuItem.hpp"
using Exponent::GUI::Controls::CSelectableMenuItem;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CSelectableMenuItem, CMenuItem);

//	===========================================================================
CSelectableMenuItem::CSelectableMenuItem(const CString &text, const long id, const bool selected) 
				   : CMenuItem(text, id, e_menuItemSelectable)
				   , m_isSelected(selected)
				   , m_unCheckedImage(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CSelectableMenuItem);
}	

//	===========================================================================
CSelectableMenuItem::~CSelectableMenuItem()
{
	EXPONENT_CLASS_DESTRUCTION(CSelectableMenuItem);
	FORGET_COUNTED_OBJECT(m_unCheckedImage);
}